/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.util.handlers;

import java.util.Optional;
import mod.traister101.sns.common.items.ContainerItem;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.network.SNSPacketHandler;
import mod.traister101.sns.network.ServerboundPickBlockPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public final class PickBlockHandler {
    public static boolean onPickBlock(Player player, HitResult target) {
        Level world = player.m_9236_();
        if (target.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos blockPos = ((BlockHitResult)target).m_82425_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        ItemStack stackToSelect = blockState.m_60734_().getCloneItemStack(blockState, target, (BlockGetter)world, blockPos, player);
        if (stackToSelect.m_41619_()) {
            return false;
        }
        SNSPacketHandler.sendToServer(new ServerboundPickBlockPacket(stackToSelect));
        return true;
    }

    public static void handlePickBlock(ServerPlayer player, ItemStack stackToSelect) {
        Inventory inventoryPlayer = player.m_150109_();
        if (!PickBlockHandler.hasSpace(inventoryPlayer)) {
            return;
        }
        ItemStack foundStack = PickBlockHandler.findStackInItemContainer(inventoryPlayer, stackToSelect);
        if (foundStack.m_41619_()) {
            return;
        }
        int slotIndex = inventoryPlayer.m_36062_();
        inventoryPlayer.m_6836_(slotIndex, foundStack);
        if (Inventory.m_36045_((int)slotIndex)) {
            inventoryPlayer.f_35977_ = slotIndex;
        } else {
            inventoryPlayer.m_36038_(slotIndex);
        }
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, inventoryPlayer.f_35977_, inventoryPlayer.m_8020_(inventoryPlayer.f_35977_)));
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, slotIndex, inventoryPlayer.m_8020_(slotIndex)));
        player.f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(inventoryPlayer.f_35977_));
    }

    private static ItemStack findStackInItemContainer(Inventory inventoryPlayer, ItemStack stackToMatch) {
        Optional optionalCuriosItemHandler;
        if (ModList.get().isLoaded("curios") && (optionalCuriosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)inventoryPlayer.f_35978_).resolve()).isPresent()) {
            ICuriosItemHandler curiosItemHandler = (ICuriosItemHandler)optionalCuriosItemHandler.get();
            IItemHandlerModifiable equippedCurios = curiosItemHandler.getEquippedCurios();
            for (int curiosSlotIndex = 0; curiosSlotIndex < equippedCurios.getSlots(); ++curiosSlotIndex) {
                Optional resolve;
                ItemStack itemContainer = equippedCurios.getStackInSlot(curiosSlotIndex);
                LazyOptional itemHandlerOpt = itemContainer.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (!itemHandlerOpt.isPresent() || !((Boolean)SNSConfig.SERVER.allPickBlock.get()).booleanValue() && !(itemContainer.m_41720_() instanceof ContainerItem) || (resolve = itemHandlerOpt.resolve()).isEmpty()) continue;
                IItemHandler handler = (IItemHandler)resolve.get();
                for (int slotIndex = 0; slotIndex < handler.getSlots(); ++slotIndex) {
                    ItemStack slotStack = handler.getStackInSlot(slotIndex);
                    if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stackToMatch)) continue;
                    int extractAmount = slotStack.m_41741_();
                    return handler.extractItem(slotIndex, extractAmount, false);
                }
            }
        }
        for (ItemStack itemContainer : inventoryPlayer.f_35974_) {
            Optional resolve;
            LazyOptional itemHandlerOpt = itemContainer.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (!itemHandlerOpt.isPresent() || !((Boolean)SNSConfig.SERVER.allPickBlock.get()).booleanValue() && !(itemContainer.m_41720_() instanceof ContainerItem) || (resolve = itemHandlerOpt.resolve()).isEmpty()) continue;
            IItemHandler handler = (IItemHandler)resolve.get();
            for (int slotIndex = 0; slotIndex < handler.getSlots(); ++slotIndex) {
                ItemStack slotStack = handler.getStackInSlot(slotIndex);
                if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stackToMatch)) continue;
                int extractAmount = slotStack.m_41741_();
                return handler.extractItem(slotIndex, extractAmount, false);
            }
        }
        return ItemStack.f_41583_;
    }

    private static boolean hasSpace(Inventory inventoryPlayer) {
        for (ItemStack itemStack : inventoryPlayer.f_35974_) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private PickBlockHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

